import math
import numpy as np
import random
import matplotlib.pyplot as plt

def pull_arm(i,a,mu):
    X = random.uniform(0, 1)
    if X < mu[i][a]:
        return 1
    else:
        return 0

def CI(i,k,t,N,n,alpha_1):
    C = (2*N*math.log(t)/n[i][k])**0.5 + alpha_1
    return C

def ArgMaxK(Q,agent,M):
    a_i = 0
    for arm in range(M):
        if Q[agent][arm]>Q[agent][a_i]:
            a_i = arm
    return a_i

def RandomSelect(A,agent):
    random_num = random.randint(0, len(A[agent])-1)
    return random_num




def GossipUCB(N,M,alpha1,T,mu,Neighbor,best_arm):

    N = 8
    M = 10
    alpha1 = 64/(N**17)

    T = int(1e4)

    W_old = np.array([[0.5, 0.2, 0.3], [0.2, 0.4, 0.4], [0.3, 0.4, 0.3]])
    #W = np.array([[0, 0.5, 0.5], [0.5, 0, 0.5], [0.5, 0.5, 0]])
    W = np.array([[0.2, 0.2, 0.2, 0, 0, 0, 0.2, 0.2],
                  [0.2, 0.2, 0.2, 0.2, 0, 0, 0, 0.2],
                  [0.2, 0.2, 0.2, 0.2, 0.2, 0, 0, 0],
                  [0, 0.2, 0.2, 0.2, 0.2, 0.2, 0, 0],
                  [0, 0, 0.2, 0.2, 0.2, 0.2, 0.2, 0],
                  [0, 0, 0, 0.2, 0.2, 0.2, 0.2, 0.2],
                  [0.2, 0, 0, 0, 0.2, 0.2, 0.2, 0.2],
                  [0.2, 0.2, 0, 0, 0, 0.2, 0.2, 0.2]])

    #mu = np.array([[0.6, 0.6, 0.8, 0.5, 0.2], [0.3, 0.9, 0.6, 0.5, 0.1], [0.3, 0.3, 0.7, 0.5, 0.6]]) #arm 3
    mu = np.array([
        [0.8, 0.9, 0.95, 0.85, 0.85, 0.8, 0.7, 0.65, 0.75, 0.75],
        [0.7, 0.6, 0.2, 0.1, 0.7, 0.2, 0.3, 0.5, 0.7, 0.4],
        [0.3, 0.3, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.6, 0.6],
        [0.6, 0.5, 0.7, 0.3, 0.85, 0.9, 0.6, 0.6, 0.3, 0.3],
        [0.7, 0.6, 0.8, 0.2, 0.85, 0.3, 0.3, 0.5, 0.3, 0.2],
        [0.5, 0.7, 0.9, 0.7, 0.9, 0.7, 0.6, 0.5, 0.3, 0.6],
        [0.4, 0.5, 0.7, 0.7, 0.7, 0.8, 0.3, 0.7, 0.7, 0.5],
        [0.3, 0.4, 0.6, 0.7, 0.75, 0.7, 0.5, 0.4, 0.2, 0.3]
    ])
    # mu = np.array([
    #     [0.1, 0.1, 0.1, 0.1, 0.85, 0.8, 0.7, 0.65, 0.75, 0.75],
    #     [0.7, 0.6, 0.2, 0.1, 0.7, 0.2, 0.3, 0.5, 0.1, 0.4],
    #     [0.3, 0.3, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.6, 0.6],
    #     [0.6, 0.5, 0.7, 0.3, 0.85, 0.1, 0.6, 0.6, 0.3, 0.3],
    #     [0.1, 0.6, 0.1, 0.2, 0.85, 0.3, 0.3, 0.5, 0.3, 0.2],
    #     [0.5, 0.7, 0.1, 0.1, 0.9, 0.7, 0.6, 0.5, 0.3, 0.6],
    #     [0.4, 0.5, 0.1, 0.1, 0.7, 0.8, 0.3, 0.7, 0.1, 0.5],
    #     [0.3, 0.4, 0.6, 0.1, 0.75, 0.7, 0.5, 0.4, 0.2, 0.3]
    # ])
    Neighbor = np.array([[1, 2, 6, 7],
                         [0, 2, 3, 7],
                         [0, 1, 3, 4],
                         [1, 2, 4, 5],
                         [2, 3, 5, 6],
                         [3, 4, 6, 7],
                         [0, 4, 5, 7],
                         [0, 1, 5, 6]])
    mu_star = column_means = np.mean(mu, axis=0)
    best_arm = 4

    # lamda2 = 0.2732

    X_tilde = np.zeros((N,M,2)) # [sum of reward , pull times]
    n = np.zeros((N,M))    #number of pull
    sita = np.zeros((N,M))    #estimation of the global value
    X = np.zeros((N,M))           #local reward
    n_tilde = np.zeros((N, M))    #max number of the agent to pull the arm
    sum_reward = np.zeros((N, M))
    sum_pull_time = np.zeros((N, M))
    regret_list = [[0],[0],[0],[0],[0],[0],[0],[0]]


    # 1 Initialization
    """for agent in range(N):
        for arm in range(M):
            X[agent][arm] = pull_arm(agent,arm,mu)
            X_tilde[agent][arm][0] += X[agent][arm]
            X_tilde[agent][arm][1] += 1
            sita[agent][arm] = X[agent][arm]
            n[agent][arm] = 1
            n_tilde[agent][arm] = 1
"""
    # Initialization
    for agent in range(N):
        for arm in range(M):
            X[agent][arm] = pull_arm(agent, arm, mu)
            X_tilde[agent][arm][0] += X[agent][arm]
            X_tilde[agent][arm][1] += 1
            sita[agent][arm] = X[agent][arm]
            n[agent][arm] = 1
            n_tilde[agent][arm] = 1
            #sum_reward[agent][arm] += X[agent][arm]
            #sum_pull_time[agent][arm] += 1
            #regret_list[agent].append((regret_list[agent][-1] + mu_star[best_arm] - mu_star[arm]))



    for t in range(1,T+1):  # T
        A = [set() for _ in range(N)]

        new_n_tilde = np.zeros((N, M))
        for agent in range(N):
            for arm in range(M):
                #line 5
                for nei in Neighbor[agent]:
                    new_n_tilde[agent][arm] = max(n_tilde[nei][arm], n[agent][arm], new_n_tilde[agent][arm])        #计算arm被哪个agentpull的次数最多


        for agent in range(N):
            for arm in range(M):
                #line 6
                if n[agent][arm] < n_tilde[agent][arm] - N:
                    A[agent].add(arm)

        n_tilde = new_n_tilde

        a = np.zeros(N)
        Q = np.zeros((N, M))
        for agent in range(N):
            if not A[agent]:
                for arm in range(M):
                    #line 9
                    Q[agent][arm] = sita[agent][arm] + CI(agent,arm,t,N,n,alpha1)
                    #line 10
                a[agent] = ArgMaxK(Q,agent,M)
            else:
                #print(A[agent])
                #print(RandomSelect(A,agent))
                a[agent] = list(A[agent])[RandomSelect(A,agent)]
                #print("t:",t,"a[agent]:",a[agent])

        X_tilde_old = np.zeros((N,M))
        for agent in range(N):
            for arm in range(M):
                X_tilde_old[agent][arm] =  X_tilde[agent][arm][0] / X_tilde[agent][arm][1]
        for agent in range(N):
            X[agent][int(a[agent])] = pull_arm(agent, int(a[agent]), mu)
            X_tilde[agent][int(a[agent])][0] += X[agent][int(a[agent])]
            X_tilde[agent][int(a[agent])][1] += 1

            sum_reward[agent][int(a[agent])] += X[agent][int(a[agent])]
            sum_pull_time[agent][int(a[agent])] += 1
            regret_list[agent].append((regret_list[agent][-1] + mu_star[best_arm] - mu_star[int(a[agent])]))

        for agent in range(N):
            n[agent][int(a[agent])] += 1

        random_x = random.uniform(0, 1)

        new_sita = np.zeros((N,M))
        for i in range(N):
            gossip_agent = random.choice(Neighbor[i])
            for k in range(M):
                new_sita[i][k] = (sita[i][k]+sita[gossip_agent][k])/2 + X_tilde[i][k][0]/X_tilde[i][k][1] - X_tilde_old[i][k]
        sita = new_sita
    return regret_list

if __name__ == '__main__':



    N = 8
    M = 10
    alpha1 = 64 / (N ** 17)
    mu = np.array([
        [0.1, 0.1, 0.1, 0.1, 0.85, 0.8, 0.7, 0.65, 0.75, 0.75],
        [0.7, 0.6, 0.2, 0.1, 0.7, 0.2, 0.3, 0.5, 0.1, 0.4],
        [0.3, 0.3, 0.6, 0.4, 0.8, 0.4, 0.5, 0.7, 0.6, 0.6],
        [0.6, 0.5, 0.7, 0.3, 0.85, 0.1, 0.6, 0.6, 0.3, 0.3],
        [0.1, 0.6, 0.1, 0.2, 0.85, 0.3, 0.3, 0.5, 0.3, 0.2],
        [0.5, 0.7, 0.1, 0.1, 0.9, 0.7, 0.6, 0.5, 0.3, 0.6],
        [0.4, 0.5, 0.1, 0.1, 0.7, 0.8, 0.3, 0.7, 0.1, 0.5],
        [0.3, 0.4, 0.6, 0.1, 0.75, 0.7, 0.5, 0.4, 0.2, 0.3]
    ])
    T = int(1e4)
    Neighbor = np.array([[1, 2, 6, 7],
                         [0, 2, 3, 7],
                         [0, 1, 3, 4],
                         [1, 2, 4, 5],
                         [2, 3, 5, 6],
                         [3, 4, 6, 7],
                         [0, 4, 5, 7],
                         [0, 1, 5, 6]])
    best_arm = 4
    repeated_time = 10

    regret_list_zero_1 = []
    for repeat_time in range(repeated_time):
        regret_list = GossipUCB(N, M, alpha1, T, mu, Neighbor, best_arm)
        regret_list_zero_1.append([sum(items) for items in zip(*regret_list)])
        # print(sums)

    min_length = len(regret_list_zero_1[0])
    # 遍历嵌套列表中的每个列表
    for inner_list in regret_list_zero_1:
        # 更新最小长度
        min_length = min(min_length, len(inner_list))
    print((regret_list_zero_1))
    regret_list_zero_np_1 = np.array(regret_list_zero_1)
    regret_mean_1 = np.mean(regret_list_zero_np_1, axis=0)
    regret_std_1 = np.std(regret_list_zero_np_1, axis=0)

    index_list = range(min_length)

    MARKERS = ["o", "D", "s", "^", "v", "p", "*"]
    COLORS = ["#0e5ad3", "#bc2d14", "#22aa16", "#a011a3", "#d1ba0e", "#14ccc2", "#d67413"]
    LINES = ["solid", "dashed", "dashdot", "dotted", "solid", "dashed", "dashdot", "dotted"]

    # for i in range(len(regret_mean)):

    plt.plot(index_list, regret_mean_1, color='green',
             linestyle='--', label='Gossip_bandit')
    plt.fill_between(index_list, regret_mean_1 - regret_std_1, regret_mean_1 + regret_std_1, color='lightgreen',
                     alpha=0.7)

    plt.grid(True, linestyle='--')
    # plt.title('regret')
    plt.xlabel('time')
    plt.ylabel('average regret of each agent')
    plt.legend()
    plt.show()


    with open('list_data_GossipUCB_mean.txt', 'w') as f:
        for item in regret_mean_1:
            f.write('%s\n' % item)

    with open('list_data_Gossip_std.txt', 'w') as f:
        for item in regret_std_1:
            f.write('%s\n' % item)
